/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.api.recipes.barrel.BarrelRecipe;
import net.dries007.tfc.client.FluidSpriteCache;
import net.dries007.tfc.client.button.GuiButtonBarrelSeal;
import net.dries007.tfc.client.button.IButtonTooltip;
import net.dries007.tfc.client.gui.GuiContainerTE;
import net.dries007.tfc.network.PacketGuiButton;
import net.dries007.tfc.objects.container.ContainerBarrel;
import net.dries007.tfc.objects.te.TEBarrel;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.lwjgl.opengl.GL11;

public class GuiBarrel
extends GuiContainerTE<TEBarrel> {
    public static final ResourceLocation BARREL_BACKGROUND = new ResourceLocation("tfc", "textures/gui/barrel.png");
    private final String translationKey;

    public GuiBarrel(Container container, InventoryPlayer playerInv, TEBarrel tile, String translationKey) {
        super(container, playerInv, tile, BARREL_BACKGROUND);
        this.translationKey = translationKey;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.func_189646_b(new GuiButtonBarrelSeal((TEBarrel)this.tile, 0, this.field_147009_r, this.field_147003_i));
    }

    protected void func_191948_b(int mouseX, int mouseY) {
        Object tooltip;
        IFluidHandler tank;
        super.func_191948_b(mouseX, mouseY);
        int relX = mouseX - this.field_147003_i;
        int relY = mouseY - this.field_147009_r;
        if (relX >= 7 && relY >= 19 && relX < 25 && relY < 71 && (tank = ((ContainerBarrel)this.field_147002_h).getBarrelTank()) != null) {
            FluidStack fluid = tank.getTankProperties()[0].getContents();
            tooltip = new ArrayList();
            if (fluid == null || fluid.amount == 0) {
                tooltip.add(I18n.func_135052_a((String)"tfc.tooltip.barrel_empty", (Object[])new Object[0]));
            } else {
                tooltip.add(fluid.getLocalizedName());
                tooltip.add(TextFormatting.GRAY.toString() + I18n.func_135052_a((String)"tfc.tooltip.barrel_fluid_amount", (Object[])new Object[]{fluid.amount}));
            }
            this.drawHoveringText((List)tooltip, mouseX, mouseY, this.field_146289_q);
        }
        for (GuiButton button : this.field_146292_n) {
            if (!(button instanceof IButtonTooltip) || !button.func_146115_a() || !(tooltip = (IButtonTooltip)button).hasTooltip()) continue;
            this.func_146279_a(I18n.func_135052_a((String)tooltip.getTooltip(), (Object[])new Object[0]), mouseX, mouseY);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String name = I18n.func_135052_a((String)(this.translationKey + ".name"), (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(name, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(name) / 2, 6, 0x404040);
        if (((TEBarrel)this.tile).isSealed()) {
            IItemHandler handler = (IItemHandler)((TEBarrel)this.tile).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            if (handler != null) {
                GL11.glDisable((int)2929);
                for (int slotId = 0; slotId < handler.getSlots(); ++slotId) {
                    this.drawSlotOverlay(this.field_147002_h.func_75139_a(slotId));
                }
                GL11.glEnable((int)2929);
            }
            boolean isLong = false;
            BarrelRecipe recipe = ((TEBarrel)this.tile).getRecipe();
            if (recipe != null) {
                String resultName = recipe.getResultName();
                int recipeWidth = this.field_146289_q.func_78256_a(resultName);
                if (recipeWidth > 80) {
                    isLong = true;
                }
                this.field_146289_q.func_78276_b(resultName, this.field_146999_f / 2 - (isLong ? recipeWidth / 2 - 6 : 28), isLong ? 73 : 61, 0x404040);
            }
            this.field_146289_q.func_78276_b(((TEBarrel)this.tile).getSealedDate(), this.field_146999_f / 2 - (isLong ? 28 : this.field_146289_q.func_78256_a(((TEBarrel)this.tile).getSealedDate()) / 2), isLong ? 19 : 73, 0x404040);
        }
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int fillHeightPixels;
        IFluidTankProperties t;
        FluidStack fs;
        ContainerBarrel container;
        IFluidHandler tank;
        super.func_146976_a(partialTicks, mouseX, mouseY);
        if (Helpers.isJEIEnabled()) {
            this.func_73729_b(this.field_147003_i + 92, this.field_147009_r + 21, 227, 0, 9, 14);
        }
        if ((tank = (container = (ContainerBarrel)this.field_147002_h).getBarrelTank()) != null && (fs = (t = tank.getTankProperties()[0]).getContents()) != null && (fillHeightPixels = (int)((float)(50 * fs.amount) / (float)t.getCapacity())) > 0) {
            Fluid fluid = fs.getFluid();
            TextureAtlasSprite sprite = FluidSpriteCache.getStillSprite(fluid);
            int positionX = this.field_147003_i + 8;
            int positionY = this.field_147009_r + 54;
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            int color = fluid.getColor();
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            float a = (float)(color >> 24 & 0xFF) / 255.0f;
            GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            while (fillHeightPixels > 15) {
                buffer.func_181662_b((double)positionX, (double)positionY, 0.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94206_g()).func_181675_d();
                buffer.func_181662_b((double)positionX, (double)(positionY + 16), 0.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94210_h()).func_181675_d();
                buffer.func_181662_b((double)(positionX + 16), (double)(positionY + 16), 0.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94210_h()).func_181675_d();
                buffer.func_181662_b((double)(positionX + 16), (double)positionY, 0.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94206_g()).func_181675_d();
                fillHeightPixels -= 16;
                positionY -= 16;
            }
            if (fillHeightPixels > 0) {
                int blank = 16 - fillHeightPixels;
                buffer.func_181662_b((double)positionX, (double)(positionY += blank), 0.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94207_b((double)blank)).func_181675_d();
                buffer.func_181662_b((double)positionX, (double)(positionY + fillHeightPixels), 0.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94210_h()).func_181675_d();
                buffer.func_181662_b((double)(positionX + 16), (double)(positionY + fillHeightPixels), 0.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94210_h()).func_181675_d();
                buffer.func_181662_b((double)(positionX + 16), (double)positionY, 0.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94207_b((double)blank)).func_181675_d();
            }
            Tessellator.func_178181_a().func_78381_a();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(BARREL_BACKGROUND);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        this.func_73729_b(this.field_147003_i + 7, this.field_147009_r + 19, 176, 0, 18, 52);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        TerraFirmaCraft.getNetwork().sendToServer((IMessage)new PacketGuiButton(button.field_146127_k));
        super.func_146284_a(button);
    }
}

